#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>

int	do_fcntl(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int retval;
    int fd = a0;
    int cmd = a1;
    int arg;
    
    switch(cmd) {
	case X86_F_DUPFD:
	    retval = fcntl(fd, F_DUPFD, a2);
	    break;
	case X86_F_GETFD:
	    retval = fcntl(fd, F_GETFD);
	    break;
	case X86_F_SETFD:
	    retval = fcntl(fd, F_SETFD, a2);
	    break;
	case X86_F_GETFL:
	    retval = fcntl(fd, F_GETFL);
	    break;
	case X86_F_SETFL:
	    arg = 0;
	    if(a2 & X86_O_APPEND) {
		arg |= O_APPEND;
	    }
	    if(a2 & X86_O_NONBLOCK) {
		arg |= O_NONBLOCK;
	    }
	    retval = fcntl(fd, F_SETFL, arg);
	    break;
	case X86_F_GETOWN:
	    retval = fcntl(fd, F_GETOWN);
	    break;
	case X86_F_SETOWN:
	    retval = fcntl(fd, F_SETOWN, a2);
	    break;
	case X86_F_GETLK: {
	    struct x86_flock *	xlp;
	    struct flock	lck;

	    xlp = ARG_TO_POINTER(a2);
	    retval = fcntl(fd, F_GETLK, &lck);
	    if(retval != -1) {
		switch(lck.l_type) {
		    case F_RDLCK:
			xlp->l_type = X86_F_RDLCK;
			break;
		    case F_WRLCK:
			xlp->l_type = X86_F_WRLCK;
			break;
		    case F_UNLCK:
			xlp->l_type = X86_F_UNLCK;
			break;
		}
		xlp->l_whence = lck.l_whence;
		xlp->l_start = lck.l_start;
		xlp->l_len = lck.l_len;
		xlp->l_pid = lck.l_pid;
	    }
	}
	case X86_F_SETLK:
	case X86_F_SETLKW: {
	    struct x86_flock *	xlp;
	    struct flock	lck;

	    xlp = ARG_TO_POINTER(a2);
	    switch(xlp->l_type) {
		case X86_F_RDLCK:
		    lck.l_type = X86_F_RDLCK;
		    break;
		case X86_F_WRLCK:
		    lck.l_type = X86_F_WRLCK;
		    break;
		case X86_F_UNLCK:
		    lck.l_type = X86_F_UNLCK;
		    break;
	    }
	    lck.l_whence = xlp->l_whence;
	    lck.l_start = xlp->l_start;
	    lck.l_len = xlp->l_len;
	    lck.l_pid = xlp->l_pid;

	    if(cmd == X86_F_SETLK) {
		retval = fcntl(fd, F_SETLK, &lck);
	    }
	    if(cmd == X86_F_SETLKW) {
		retval = fcntl(fd, F_SETLKW, &lck);
	    }
	}
    }

    if(retval == -1) {
	return(-alpha_to_intel_errno(errno));
    }
    else {
	return(retval);
    }
}


