#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>
#include <unistd.h>
#include <linux/dirent.h>
#include <linux/unistd.h>
#include <stdlib.h>
#include <string.h>


int	do_getdents(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int fd = a0;
    char *xcp = ARG_TO_POINTER(a1);
    struct x86_dirent * xdp;
    unsigned int count = a2;
    char *tmpbuf;
    char *cp;
    struct dirent *dp;
    int retval;
    int remainder;
    int byte_count;

    /* Allocate a temporary buffer */
    cp = tmpbuf = (char *)malloc(count);

    /* Scoop up some dirents */
    retval = __getdents(fd, tmpbuf, count);

    /* Bail out if error */
    if(retval == -1) {
	free(tmpbuf);
	return(-alpha_to_intel_errno(errno));
    }

    /* Massage the Alpha-style dirents into Intel-style.  This is
     * UGLY; it depends on knowledge of the relative data sizes.
     */
    remainder = retval;
    byte_count = 0;
    while(remainder > 0) {
	dp = (struct dirent *)cp;
	xdp = (struct x86_dirent *)xcp;
	xdp->d_ino = dp->d_ino;
	xdp->d_off = dp->d_off;
	xdp->d_reclen = dp->d_reclen - 8;
	if(dp->d_reclen >= 274) {
	    strncpy(xdp->d_name, dp->d_name, 256);
	}
	else {
	    strcpy(xdp->d_name, dp->d_name);
	}
	remainder -= dp->d_reclen;
  	byte_count += xdp->d_reclen;
	cp += dp->d_reclen;
	xcp += xdp->d_reclen;
    }

    return(byte_count);
    
}

