#include <stdio.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <syscall_thunk.h>
#include <errno.h>

char *	x86_brk = NULL;
char *	x86_original_brk = NULL;

void	x86_set_brk(char * brk)
{
    x86_original_brk = x86_brk = brk;
}

unsigned int	do_brk(int a0, int a1, int a2, int a3, int a4, int a5)
{
    char *newbrk = ARG_TO_POINTER(a0);
    char * brkpage;
    int		new_alloc_size;
    caddr_t	mapped_addr;
    unsigned int retval;

    /* If called with an arg of zero, return the current brk */
    if(a0 == 0) {
	retval = ARG_TO_POINTER(x86_brk);
    	return(retval);
    }

    /* We can *never* set the brk to less than what we started with... */
    if(newbrk < x86_original_brk) {
	return(-ENOMEM);
    }

    /* Calculate the address of the top of the page where the brk is
     * currently located...
     */
    brkpage = (char *)(((unsigned long)x86_brk + ALPHA_PAGE_SIZE - 1) & ALPHA_PAGE_MASK);

    /* If the new brk is less than this, set it and we're done... */
    if(newbrk < brkpage) {
	x86_brk = newbrk;
	retval = ARG_TO_POINTER(x86_brk);
    	return(retval);
    }

    /* We need to allocate more memory after the brk... */
    new_alloc_size = 
		(newbrk - brkpage + 1)+(ALPHA_PAGE_SIZE-1) & ALPHA_PAGE_MASK;

    mapped_addr = mmap((caddr_t)brkpage, new_alloc_size, PROT_READ|PROT_WRITE,
		MAP_ANON|MAP_FIXED|MAP_PRIVATE, 0, 0);

    if((long)mapped_addr < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    else {
	x86_brk = newbrk;
	retval = ARG_TO_POINTER(x86_brk);
    	return(retval);
    }
}

