#include <stdio.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>

int do_getgroups(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int	size = a0;
    x86_gid_t *x86_grouplist = ARG_TO_POINTER(a1);
    gid_t *grouplist;
    int retval;

    if(size > 0) {
	grouplist = (gid_t *)malloc(size * sizeof(gid_t));
	retval = getgroups(size, grouplist);
	if(retval == -1) {
	    free(grouplist);
	    return(-alpha_to_intel_errno(errno));
	}
	else {
	    int	i;
	    for(i = 0; i < size; i++) {
		x86_grouplist[i] = grouplist[i];
	    }
	    free(grouplist);
	    return(0);
	}
    }
    else {
	retval = getgroups(size, NULL);
	if(retval == -1) {
	    return(-alpha_to_intel_errno(errno));
	}
	else {
	    return(0);
	}
    }
}
	    
int do_setgroups(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int	size = a0;
    x86_gid_t *x86_grouplist = ARG_TO_POINTER(a1);
    gid_t *grouplist;
    int retval;
    int i;

    if(size > 0) {
	grouplist = (gid_t *)malloc(size * sizeof(gid_t));
	for(i = 0; i < size; i++) {
	    grouplist[i] = x86_grouplist[i];
	}
	retval = setgroups(size, grouplist);
	free(grouplist);
	if(retval == -1) {
	    return(-alpha_to_intel_errno(errno));
	}
	else {
	    return(0);
	}
    }
    else {
	return(-EINVAL);
    }
}
	    
