/* Definitions and data structures used for syscall thunking... */

#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

/* Macro for converting a syscall arg to a pointer... */
#define ARG_TO_POINTER(a)	(void *)((unsigned long)(a) & 0xffffffff)

/* Translation table for bitmasks... */
typedef struct bitmask_transtbl {
	unsigned int	x86_mask;
	unsigned int	x86_bits;
	unsigned int	alpha_mask;
	unsigned int	alpha_bits;
} bitmask_transtbl;

/* Translation table for parameters... */
typedef struct param_transtbl {
	unsigned int	x86_param;
	unsigned int	alpha_param;
} param_transtbl;


#define ALPHA_PAGE_SIZE 0x2000
#define ALPHA_PAGE_MASK 0xffffe000

/* stat, fstat, lstat */

struct x86_new_stat {
        unsigned short st_dev;
        unsigned short __pad1;
        unsigned int st_ino;
        unsigned short st_mode;
        unsigned short st_nlink;
        unsigned short st_uid;
        unsigned short st_gid;
        unsigned short st_rdev;
        unsigned short __pad2;
        unsigned int  st_size;
        unsigned int  st_blksize;
        unsigned int  st_blocks;
        unsigned int  st_atime;
        unsigned int  __unused1;
        unsigned int  st_mtime;
        unsigned int  __unused2;
        unsigned int  st_ctime;
        unsigned int  __unused3;
        unsigned int  __unused4;
        unsigned int  __unused5;
};

struct x86_old_stat {
        unsigned short st_dev;
        unsigned short st_ino;
        unsigned short st_mode;
        unsigned short st_nlink;
        unsigned short st_uid;
        unsigned short st_gid;
        unsigned short st_rdev;
        unsigned int   st_size;
        unsigned int   st_atime;
        unsigned int   st_mtime;
        unsigned int   st_ctime;
};



/* mmap */
#define X86_PROT_READ		0x1
#define X86_PROT_WRITE		0x2
#define X86_PROT_EXEC		0x4

#define X86_MAP_SHARED		0x0001
#define X86_MAP_PRIVATE		0x0002
#define X86_MAP_FIXED		0x0010
#define X86_MAP_ANONYMOUS 	0x0020
#define X86_MAP_GROWSDOWN 	0x0100
#define X86_MAP_DENYWRITE	0x0800
#define X86_MAP_EXECUTABLE	0x1000
#define X86_MAP_LOCKED		0x2000

/* open/fcntl */
#define X86_O_CREAT		0100
#define X86_O_EXCL		0200
#define X86_O_NOCTTY		0400
#define X86_O_TRUNC		01000
#define X86_O_APPEND		02000
#define X86_O_NONBLOCK		04000
#define X86_O_SYNC		010000
#define X86_FASYNC		020000

/* getrusage */
struct  x86_rusage {
        struct timeval ru_utime;        /* user time used */
        struct timeval ru_stime;        /* system time used */
        int    ru_maxrss;              /* maximum resident set size */
        int    ru_ixrss;               /* integral shared memory size */
        int    ru_idrss;               /* integral unshared data size */
        int    ru_isrss;               /* integral unshared stack size */
        int    ru_minflt;              /* page reclaims */
        int    ru_majflt;              /* page faults */
        int    ru_nswap;               /* swaps */
        int    ru_inblock;             /* block input operations */
        int    ru_oublock;             /* block output operations */
        int    ru_msgsnd;              /* messages sent */
        int    ru_msgrcv;              /* messages received */
        int    ru_nsignals;            /* signals received */
        int    ru_nvcsw;               /* voluntary context switches */
        int    ru_nivcsw;              /* involuntary " */
};

/* utime */
struct x86_utimbuf {
	unsigned int	actime;
	unsigned int	modtime;
};

/* ftime */
struct x86_timeb {
	unsigned int	time;
	unsigned short	millitm;
	short		timezone;
	short		dstflag;
};

/* times */
struct x86_tms {
	unsigned int	tms_utime;
	unsigned int	tms_stime;
	unsigned int	tms_cutime;
	unsigned int	tms_cstime;
};

/* various flavors of utsname */
struct x86_oldold_utsname {
        char sysname[9];
        char nodename[9];
        char release[9];
        char version[9];
        char machine[9];
};

struct x86_old_utsname {
        char sysname[65];
        char nodename[65];
        char release[65];
        char version[65];
        char machine[65];
};

struct x86_new_utsname {
        char sysname[65];
        char nodename[65];
        char release[65];
        char version[65];
        char machine[65];
        char domainname[65];
};

/* mlockall */
#define X86_MCL_CURRENT		1
#define X86_MCL_FUTURE		2

/* sigaction */
struct x86_sigaction {
	unsigned int	sa_handler;
	unsigned int	sa_mask;
	int		sa_flags;
	unsigned int	sa_restorer;	/* unused, but here for compatibility */
};

/* sa_flags values */
#define X86_SA_NOCLDSTOP    1
#define X86_SA_SHIRQ        0x04000000
#define X86_SA_STACK        0x08000000
#define X86_SA_RESTART      0x10000000
#define X86_SA_INTERRUPT    0x20000000
#define X86_SA_NOMASK       0x40000000
#define X86_SA_ONESHOT      0x80000000

#define X86_SIG_DFL	0
#define X86_SIG_IGN	1
#define X86_SIG_ERR	0xffffffff

#define X86_SIG_BLOCK	0
#define X86_SIG_UNBLOCK 1
#define X86_SIG_SETMASK	2

/* fcntl */
#define X86_F_DUPFD         0       /* dup */
#define X86_F_GETFD         1       /* get f_flags */
#define X86_F_SETFD         2       /* set f_flags */
#define X86_F_GETFL         3       /* more flags (cloexec) */
#define X86_F_SETFL         4
#define X86_F_GETLK         5
#define X86_F_SETLK         6
#define X86_F_SETLKW        7

#define X86_F_SETOWN        8       /*  for sockets. */
#define X86_F_GETOWN        9       /*  for sockets. */

/* for F_[GET|SET]FL */
#define X86_FD_CLOEXEC      1       /* actually anything with low bit set goes */

/* for posix fcntl() and lockf() */
#define X86_F_RDLCK         0
#define X86_F_WRLCK         1
#define X86_F_UNLCK         2

struct x86_flock {
	short	l_type;
	short	l_whence;
	int	l_start;
	int	l_len;
	int	l_pid;
};

/* getdents */
struct x86_dirent {
	int	d_ino;
	int	d_off;
	unsigned short d_reclen;
	char	d_name[256];
};

/* setrlimit, getrlimit */
struct x86_rlimit {
	int	rlim_cur;
	int	rlim_max;
};

#define X86_RLIMIT_CPU      0       /* CPU time in ms */
#define X86_RLIMIT_FSIZE    1       /* Maximum filesize */
#define X86_RLIMIT_DATA     2       /* max data size */
#define X86_RLIMIT_STACK    3       /* max stack size */
#define X86_RLIMIT_CORE     4       /* max core file size */
#define X86_RLIMIT_RSS      5       /* max resident set size */
#define X86_RLIMIT_NPROC    6       /* max number of processes */
#define X86_RLIMIT_NOFILE   7       /* max number of open files */
#define X86_RLIMIT_MEMLOCK  8       /* max locked-in-memory address space */
#define X86_RLIMIT_AS       9       /* address space limit */

/* setgroups, getgroups, others */
typedef unsigned short	x86_uid_t;
typedef unsigned short	x86_gid_t;

/* setsockopt, getsockopt */
#define X86_SOL_SOCKET      1

#define X86_SO_DEBUG        1
#define X86_SO_REUSEADDR    2
#define X86_SO_TYPE         3
#define X86_SO_ERROR        4
#define X86_SO_DONTROUTE    5
#define X86_SO_BROADCAST    6
#define X86_SO_SNDBUF       7
#define X86_SO_RCVBUF       8
#define X86_SO_KEEPALIVE    9
#define X86_SO_OOBINLINE    10
#define X86_SO_NO_CHECK     11
#define X86_SO_PRIORITY     12
#define X86_SO_LINGER       13
#define X86_SO_BSDCOMPAT    14

/* sendmsg, recvmsg */
struct x86_msghdr {
	unsigned int	msg_name;	/* really void* */
	int		msg_namelen;
	unsigned int	msg_iov;	/* really struct iovec * */
	int		msg_iovlen;
	unsigned int	msg_control;	/* really void * */
	int		msg_controllen;
	int		msg_flags;
};

/* sendmsg, recvmsg, readv, writev */
struct x86_iovec {
	unsigned int	iov_base;	/* really void * */
	int		iov_len;
};

#define X86_UIO_MAXIOV	16
