#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>
#include <sys/uio.h>

extern int x86_trace_current_syscall;
extern FILE * x86_logfile;

int do_readv(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int fd = a0;
    struct x86_iovec * x86_vector = ARG_TO_POINTER(a1);
    size_t count = a2;
    int	i;
    struct iovec alpha_vector[X86_UIO_MAXIOV];
    int retval;

    /* Convert iovec's to 64-bit format */
    if(x86_trace_current_syscall) {
	fprintf(x86_logfile, " === iovec contents: ===\n");
    }
    for(i = 0; i < count; i++) {
	if(x86_trace_current_syscall) {
	    fprintf(x86_logfile, "    base: 0x%x, len: 0x%x\n", 
			x86_vector[i].iov_base, x86_vector[i].iov_len);
	}
	alpha_vector[i].iov_base = ARG_TO_POINTER(x86_vector[i].iov_base);
	alpha_vector[i].iov_len = x86_vector[i].iov_len;
    }

    retval = readv(fd, alpha_vector, count);
    if(retval == -1) {
	return(-alpha_to_intel_errno(errno));
    }
    else {
	return(retval);
    }
}

int do_writev(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int fd = a0;
    struct x86_iovec * x86_vector = ARG_TO_POINTER(a1);
    size_t count = a2;
    int	i;
    struct iovec alpha_vector[X86_UIO_MAXIOV];
    int retval;

    /* Convert iovec's to 64-bit format */
    if(x86_trace_current_syscall) {
	fprintf(x86_logfile, " === iovec contents: ===\n");
    }
    for(i = 0; i < count; i++) {
	if(x86_trace_current_syscall) {
	    fprintf(x86_logfile, "    base: 0x%x, len: 0x%x\n", 
			x86_vector[i].iov_base, x86_vector[i].iov_len);
	}
	alpha_vector[i].iov_base = ARG_TO_POINTER(x86_vector[i].iov_base);
	alpha_vector[i].iov_len = x86_vector[i].iov_len;
    }

    retval = writev(fd, alpha_vector, count);
    if(retval == -1) {
	return(-alpha_to_intel_errno(errno));
    }
    else {
	return(retval);
    }
}
